
/****** Object:  StoredProcedure [dbo].[sp_UpdateRespondentFromRespondentService]    Script Date: 11/22/2009 14:00:46 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_updaterespondentfromrespondentservice]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_updaterespondentfromrespondentservice]
GO
CREATE PROCEDURE [dbo].[Sp_updaterespondentfromrespondentservice]
                @ProjectId        INT,
                @UserId           INT,
                @CollectMode      INT,
                @ResRespondent    VARCHAR(10),
                @ResLanguage      INT,
                @ResTimeZone      INT,
                @ResCallBackDate  DATETIME,
                @ResIntervCall    VARCHAR(10),
                @ResCallCount     INT,
                @ResLastCallDate  DATETIME,
                @ResCompleted     BIT,
                @ResPhone         VARCHAR(20),
                @ResCodeResult    VARCHAR(2),
                @ResLastCompQuest INT,
                @DialingMode      INT = NULL -- Null => Do Not Change
AS
  UPDATE respondent
  SET    projectid = @ProjectId,
         collectmode = CASE
                         WHEN @CollectMode < 0
                         THEN collectmode
                         ELSE @CollectMode
                       END,
         modifiedby = @UserId,
         modified = Getutcdate(),
         reslanguage = @ResLanguage,
         restimezone = @ResTimeZone,
         rescallbackdate = @ResCallBackDate,
         resintervcall = @ResIntervCall,
         rescallcount = @ResCallCount,
         reslastcalldate = @ResLastCallDate,
         rescompleted = @ResCompleted,
         resphone = @ResPhone,
         rescoderesult = @ResCodeResult,
         rescall = 1,
         reslastcompquest = @ResLastCompQuest,
         DialingMode = IsNull(@DialingMode,DialingMode),
		 ResCompletedDate = CASE WHEN ResCompleted = 0 AND @ResCompleted = 1 THEN GETUTCDATE() ELSE NULL END
  WHERE  resrespondent = @ResRespondent
  
  IF @@ROWCOUNT = 0
    BEGIN
      INSERT INTO respondent
                 (resrespondent,
                  projectid,
                  collectmode,
                  modifiedby,
                  modified,
                  reslanguage,
                  restimezone,
                  rescallbackdate,
                  resintervcall,
                  restimeslot,
                  rescallcount,
                  reslastcalldate,
                  resversion,
                  respriority,
                  rescompleted,
                  resconfidphone,
                  resseed,
                  resphone,
                  rescoderesult,
                  reswaveno,
                  resblocked,
                  rescomppredictive,
                  rescall,
                  resmonitored,
                  reslastcompquest,
                  respreviouscalldate,
                  reswaveimportno,
                  DialingMode,
				  ResCompletedDate)
      VALUES     (@ResRespondent,
                  @ProjectId,
                  @CollectMode,
                  @UserId,
                  Getutcdate(),
                  @ResLanguage,
                  @ResTimeZone,
                  @ResCallBackDate,
                  @ResIntervCall,
                  0,
                  @ResCallCount,
                  @ResLastCallDate,
                  '',
                  0,
                  @ResCompleted,
                  '',
                  @ResRespondent,
                  @ResPhone,
                  @ResCodeResult,
                  0,
                  0,
                  0,
                  1,
                  0,
                  @ResLastCompQuest,
                  0,
                  0,
                  IsNull(@DialingMode,0),
				  CASE WHEN @ResCompleted = 1 THEN GETUTCDATE() ELSE NULL END )
    END

GO

